package com.ejie.ab18a.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aTipoPeticion;
import com.ejie.ab18a.utils.Utilidades;

/**
 * Ab18aTipoPeticionDaoImpl generated by XXXX, 03-feb-2017 12:02:31.
 * 
 * @author XXXX
 */

@Repository
@Transactional
public class Ab18aTipoPeticionDaoImpl implements Ab18aTipoPeticionDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Ab18aTipoPeticion> rwMap = new RowMapper<Ab18aTipoPeticion>() {
		public Ab18aTipoPeticion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aTipoPeticion(resultSet.getLong("T02IDTIPOENVIO"), resultSet.getString("T02DESCES"), resultSet.getString("T02DESCEU"),
					resultSet.getDate("T02FECHABAJA"), resultSet.getString("T02CODTIPOENVIO"));
		}
	};

	private RowMapper<Ab18aTipoPeticion> rwMapPK = new RowMapper<Ab18aTipoPeticion>() {
		public Ab18aTipoPeticion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aTipoPeticion(resultSet.getLong("T02IDTIPOENVIO"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Ab18aTipoPeticion>> rwMapJerarquia = new RowMapper<JerarquiaDto<Ab18aTipoPeticion>>() {
		public JerarquiaDto<Ab18aTipoPeticion> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Ab18aTipoPeticion tipoPeticion = new Ab18aTipoPeticion(resultSet.getLong("T02IDTIPOENVIO"), resultSet.getString("T02DESCES"),
					resultSet.getString("T02DESCEU"), resultSet.getDate("T02FECHABAJA"), null);

			JerarquiaDto<Ab18aTipoPeticion> jerarquia = new JerarquiaDto<Ab18aTipoPeticion>();
			jerarquia.setModel(tipoPeticion);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab18a02s00 table.
	 * 
	 * @param tipoPeticion
	 *            Ab18a02s00
	 * @return Ab18a02s00
	 * @throws Exception
	 */
	public Ab18aTipoPeticion add(Ab18aTipoPeticion tipoPeticion) throws Exception {
		String query = "INSERT INTO AB18A02S00 (T02_ID_TIPO_ENVIO, T02_DESC_ES, T02_DESC_EU, T02_FECHA_BAJA, T02_COD_TIPO_ENVIO) VALUES (?,?,?,?,?)";
		tipoPeticion.setT02IdTipoEnvio(new Long(this.getNextSequenceValue("SQAB18A02")));
		this.jdbcTemplate.update(query, tipoPeticion.getT02IdTipoEnvio(), tipoPeticion.getT02DescEs(), tipoPeticion.getT02DescEu(),
				tipoPeticion.getT02FechaBaja(), tipoPeticion.getT02CodTipoEnvio());
		return tipoPeticion;
	}

	/**
	 * Updates a single row in the Ab18a02s00 table.
	 * 
	 * @param tipoPeticion
	 *            Ab18a02s00
	 * @return Ab18a02s00
	 */
	public Ab18aTipoPeticion update(Ab18aTipoPeticion tipoPeticion) {
		String query = "UPDATE AB18A02S00 SET T02_DESC_ES=?, T02_DESC_EU=?, T02_FECHA_BAJA=?, T02_COD_TIPO_ENVIO = ? WHERE T02_ID_TIPO_ENVIO=?";
		this.jdbcTemplate.update(query, tipoPeticion.getT02DescEs(), tipoPeticion.getT02DescEu(), tipoPeticion.getT02FechaBaja(),
				tipoPeticion.getT02CodTipoEnvio(), tipoPeticion.getT02IdTipoEnvio());
		return tipoPeticion;
	}

	/**
	 * Finds a single row in the Ab18a02s00 table.
	 * 
	 * @param tipoPeticion
	 *            Ab18a02s00
	 * @return Ab18a02s00
	 */
	@Transactional(readOnly = true)
	public Ab18aTipoPeticion find(Ab18aTipoPeticion tipoPeticion) {
		String query = "SELECT t1.T02_ID_TIPO_ENVIO T02IDTIPOENVIO, t1.T02_DESC_ES T02DESCES, t1.T02_DESC_EU T02DESCEU, t1.T02_FECHA_BAJA T02FECHABAJA FROM AB18A02S00 t1  WHERE t1.T02_ID_TIPO_ENVIO = ?  ";

		List<Ab18aTipoPeticion> ab18a02s00List = this.jdbcTemplate.query(query, this.rwMap, tipoPeticion.getT02IdTipoEnvio());
		return (Ab18aTipoPeticion) DataAccessUtils.uniqueResult(ab18a02s00List);
	}

	/**
	 * Removes a single row in the Ab18a02s00 table.
	 * 
	 * @param tipoPeticion
	 *            Ab18a02s00
	 * @return
	 */
	public void remove(Ab18aTipoPeticion tipoPeticion) {
		String query = "DELETE FROM AB18A02S00 WHERE T02_ID_TIPO_ENVIO=?";
		this.jdbcTemplate.update(query, tipoPeticion.getT02IdTipoEnvio());
	}

	/**
	 * Finds a list of rows in the Ab18a02s00 table.
	 * 
	 * @param tipoPeticion
	 *            Ab18a02s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18a02s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aTipoPeticion> findAll(Ab18aTipoPeticion tipoPeticion, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T02_ID_TIPO_ENVIO T02IDTIPOENVIO,t1.T02_DESC_ES T02DESCES,t1.T02_DESC_EU T02DESCEU,t1.T02_FECHA_BAJA T02FECHABAJA, t1.T02_COD_TIPO_ENVIO T02CODTIPOENVIO ");
		query.append("FROM AB18A02S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipoPeticion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aTipoPeticion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab18a02s00 table using like.
	 * 
	 * @param tipoPeticion
	 *            Ab18a02s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Ab18a02s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aTipoPeticion> findAllLike(Ab18aTipoPeticion tipoPeticion, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T02_ID_TIPO_ENVIO T02IDTIPOENVIO,t1.T02_DESC_ES T02DESCES,t1.T02_DESC_EU T02DESCEU,t1.T02_FECHA_BAJA T02FECHABAJA, t1.T02_COD_TIPO_ENVIO T02CODTIPOENVIO ");
		query.append("FROM AB18A02S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipoPeticion, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aTipoPeticion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab18a02s00 table.
	 * 
	 * @param tipoPeticion
	 *            Ab18a02s00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Ab18aTipoPeticion tipoPeticion) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB18A02S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipoPeticion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the Ab18a02s00 table using like.
	 * 
	 * @param tipoPeticion
	 *            Ab18a02s00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Ab18aTipoPeticion tipoPeticion, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB18A02S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipoPeticion, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Reorder the data list of Ab18a02s00 selected for rup_table
	 * 
	 * @param tipoPeticion
	 *            Ab18a02s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a02s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aTipoPeticion>> reorderSelection(Ab18aTipoPeticion tipoPeticion, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T02_ID_TIPO_ENVIO T02IDTIPOENVIO,t1.T02_DESC_ES T02DESCES,t1.T02_DESC_EU T02DESCEU,t1.T02_FECHA_BAJA T02FECHABAJA ");
		// FROM
		query.append("FROM AB18A02S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipoPeticion, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(query, jqGridRequestDto, Ab18aTipoPeticion.class, filterParamList,
				"T02_ID_TIPO_ENVIO");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Ab18aTipoPeticion>(this.rwMapPK,
				jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Ab18a02s00
	 * @param searchParams
	 *            Ab18a02s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a02s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aTipoPeticion>> search(Ab18aTipoPeticion filterParams, Ab18aTipoPeticion searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T02_ID_TIPO_ENVIO T02IDTIPOENVIO,t1.T02_DESC_ES T02DESCES,t1.T02_DESC_EU T02DESCEU,t1.T02_FECHA_BAJA T02FECHABAJA ");
		// FROM
		query.append("FROM AB18A02S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(query, jqGridRequestDto, Ab18aTipoPeticion.class, filterParamList,
				searchSQL, searchParamList, from_alias, "T02_ID_TIPO_ENVIO");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Ab18aTipoPeticion>(this.rwMapPK,
				jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filterab18a02s00
	 *            Ab18a02s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Ab18aTipoPeticion filterab18a02s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.T02_ID_TIPO_ENVIO T02IDTIPOENVIO,t1.T02_DESC_ES T02DESCES,t1.T02_DESC_EU T02DESCEU,t1.T02_FECHA_BAJA T02FECHABAJA ");
		// FROM
		query.append("FROM AB18A02S00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab18a02s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto, Ab18aTipoPeticion.class, query, params,
				"T02_ID_TIPO_ENVIO");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab18a02s00 table.
	 * 
	 * @param filterAb18a02s00
	 *            Ab18a02s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Ab18a02s00>>
	 */
	@Override
	public List<JerarquiaDto<Ab18aTipoPeticion>> findAllLikeJerarquia(Ab18aTipoPeticion filterAb18a02s00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T02_ID_TIPO_ENVIO T02IDTIPOENVIO,t1.T02_DESC_ES T02DESCES,t1.T02_DESC_EU T02DESCEU,t1.T02_FECHA_BAJA T02FECHABAJA ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB18A02S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A02S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a02s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "T02_ID_TIPO_ENVIO", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto, query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAb18a02s00
	 *            Ab18a02s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Ab18aTipoPeticion filterAb18a02s00, JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB18A02S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A02S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a02s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "T02_ID_TIPO_ENVIO", "ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAb18a02s00
	 *            Ab18a02s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Ab18a02s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aTipoPeticion>> findAllChild(Ab18aTipoPeticion filterAb18a02s00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AB18A02S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A02S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a02s00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "T02_ID_TIPO_ENVIO", "ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(), new RowNumResultSetExtractor<Ab18aTipoPeticion>(this.rwMapPK, "T02_ID_TIPO_ENVIO"),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a02s00 entity
	 * 
	 * @param tipoPeticion
	 *            Ab18a02s00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, ?> getWhereMap(Ab18aTipoPeticion tipoPeticion) {

		StringBuilder where = new StringBuilder(Ab18aTipoPeticionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipoPeticion != null && Utilidades.notNullAndNotEmpty(tipoPeticion.getT02IdTipoEnvio())) {
			where.append(" AND t1.T02_ID_TIPO_ENVIO = ?");
			params.add(tipoPeticion.getT02IdTipoEnvio());
		}
		if (tipoPeticion != null && Utilidades.notNullAndNotEmpty(tipoPeticion.getT02DescEs())) {
			where.append(" AND t1.T02_DESC_ES = ?");
			params.add(tipoPeticion.getT02DescEs());
		}
		if (tipoPeticion != null && Utilidades.notNullAndNotEmpty(tipoPeticion.getT02DescEu())) {
			where.append(" AND t1.T02_DESC_EU = ?");
			params.add(tipoPeticion.getT02DescEu());
		}
		if (tipoPeticion != null && Utilidades.notNullAndNotEmpty(tipoPeticion.getT02FechaBaja())) {
			where.append(" AND t1.T02_FECHA_BAJA = ?");
			params.add(tipoPeticion.getT02FechaBaja());
		}
		if (tipoPeticion != null && Utilidades.notNullAndNotEmpty(tipoPeticion.getT02CodTipoEnvio())) {
			where.append(" AND t1.T02_COD_TIPO_ENVIO = ?");
			params.add(tipoPeticion.getT02CodTipoEnvio());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a02s00 entity
	 * 
	 * @param tipoPeticion
	 *            Ab18a02s00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, Object> getWhereLikeMap(Ab18aTipoPeticion tipoPeticion, Boolean startsWith) {

		StringBuilder where = new StringBuilder(Ab18aTipoPeticionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipoPeticion != null && Utilidades.notNullAndNotEmpty(tipoPeticion.getT02IdTipoEnvio())) {
			where.append(" AND t1.T02_ID_TIPO_ENVIO = ?");
			params.add(tipoPeticion.getT02IdTipoEnvio());
		}
		if (tipoPeticion != null && Utilidades.notNullAndNotEmpty(tipoPeticion.getT02DescEs())) {
			where.append(" AND UPPER(t1.T02_DESC_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoPeticion.getT02DescEs().toUpperCase() + "%");
			} else {
				params.add("%" + Utilidades.filtroLikeCaracterEspecial(tipoPeticion.getT02DescEs().toUpperCase()) + "%");
			}
			where.append(" AND t1.T02_DESC_ES IS NOT NULL");
		}
		if (tipoPeticion != null && Utilidades.notNullAndNotEmpty(tipoPeticion.getT02DescEu())) {
			where.append(" AND UPPER(t1.T02_DESC_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoPeticion.getT02DescEu().toUpperCase() + "%");
			} else {
				params.add("%" + Utilidades.filtroLikeCaracterEspecial(tipoPeticion.getT02DescEu().toUpperCase()) + "%");
			}
			where.append(" AND t1.T02_DESC_EU IS NOT NULL");
		}
		if (tipoPeticion != null && Utilidades.notNullAndNotEmpty(tipoPeticion.getT02FechaBaja())) {
			where.append(" AND t1.T02_FECHA_BAJA = ?");
			params.add(tipoPeticion.getT02FechaBaja());
		}
		if (tipoPeticion != null && Utilidades.notNullAndNotEmpty(tipoPeticion.getT02CodTipoEnvio())) {
			where.append(" AND UPPER(t1.T02_COD_TIPO_ENVIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoPeticion.getT02CodTipoEnvio().toUpperCase() + "%");
			} else {
				params.add("%" + Utilidades.filtroLikeCaracterEspecial(tipoPeticion.getT02CodTipoEnvio().toUpperCase()) + "%");
			}
			where.append(" AND t1.T02_COD_TIPO_ENVIO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/*
	 * OPERACIONES CRUD
	 */
	/**
	 * @param secuencia
	 *            String
	 * @return String
	 * @throws Exception
	 *             the exception
	 */
	public int getNextSequenceValue(String secuencia) throws Exception {
		Integer sequenceValue = -1;
		try {
			String query = "SELECT " + secuencia + ".NEXTVAL FROM DUAL";
			sequenceValue = this.jdbcTemplate.queryForInt(query);
		} catch (Exception e) {
			throw new Exception(e.getMessage());
		}
		return sequenceValue;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public long findTipoEnvioByCod(String codEnvio) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB18A02S00 t1 ");

		// Where clause & Params
		StringBuilder whereBuilder = new StringBuilder(Ab18aTipoPeticionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		whereBuilder.append(" AND UPPER(t1.T02_COD_TIPO_ENVIO) = ?");
		params.add(codEnvio.toUpperCase());

		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(whereBuilder);
		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
}
